#ifndef __ROUTINE_H__
#define __ROUTINE_H__
#include "agent.h"

#define ROUTINE_COMPOSITE	1
#define ROUTINE_BUILTIN		2
#define ROUTINE_CUSTOMIZED	4

#define VALID_A_IN		(1 << 16)
#define VALID_A_OUT		(2 << 16)
#define VALID_PARAMETER		(4 << 16)
#define VALID_RESULT		(8 << 16)

/* parameters are arranged as follows: 
  the first (0's ) parameter is the number of parameters
 */



typedef struct S_ROUTINE{
	long type;
	char *name;
	char *comment;
	long result;
	long param_count;
	u64 *param_type;
	int (*execute)(struct S_ROUTINE *r,u64 * parameters,void *data,u64 *result);
	void *data;
	} ROUTINE;

typedef int (*ROUTINE_CODE)(struct S_ROUTINE *r,u64 * parameters,void *data,u64 *result);

void init_routines(void);
void delete_routine(long i);
void add_routine(char *name,char *comment, long type, long result,long param_count,u64 *param_type, void * execute , void *data);
void dump_routines(FILE *fout);
void reset_routines(void);
ROUTINE *get_routine(long index);
long get_routine_index(char *name);
int execute_routine(ROUTINE *r,u64 *result);
int evaluate_routine(long index,u64 *result);
ROUTINE *add_new_customized_routine(char *name, char *from);
ROUTINE *add_new_composite_routine(char *name);
char *get_routine_name(long index);
#endif
